*** COS 2018 11, Compute ICC 3 level last update 2022 11  
           
           
           
           
           
program define dq_acc_ic2  
syntax varlist (max=1 numeric) [if] [in], cluster_l2(varname numeric) cluster_l3(varname numeric)  [ststrata(string) stcluster(string)  controlvars(string) minclustersize_icc(int 10)  indent(int 0) forcecalc(int 1)]  
marksample touse, novarlist  
           
           
           
local indent=`indent'+5  
local adoname "dq_acc_ic2"  
local text_i "di as text _n "  					  
           
           
di _n(2) "ICC assessment for variable `varlist' with the levels `cluster_l2' `cluster_l3'" _n(2)  
           
           
*** Retrieve pointer from global to specify scalars  
local pointer "$`varlist'"  
local structure "`ststrata'_`stcluster'"  
           
tempvar constvar			  
qui gen `constvar'=1	  
tempvar clustercount		  
           
qui levelsof `varlist' if `touse'  
local varlevels = wordcount("`r(levels)'")  
           
qui levelsof som_height  
local varlevels = wordcount("`r(levels)'")  
local varlevels = wordcount("`r(levels)'")  
           
           
tempvar clustercount		  
bysort `cluster_l2': egen `clustercount' = total(`constvar')  if `touse' & `cluster_l2' < . & `varlist'<.   	  
qui tab  `clustercount', mi  
qui tab `cluster_l2' if `touse' &  `cluster_l2' < . & `varlist'<., mi  
           
           
if "`controlvars'"~="" {  
	local controlvarlist=""  
	dq_hlp_cov `controlvars' if `touse' &  `clustercount'>1	|| `cluster_l3': || `cluster_l2': ,  indent(`indent')  
	local controlvarlist="`r(controlvarlist)'"  
}          
           
           
           
else  {    
	if  `varlevels'==2 		capture noisily		xtmelogit 	`varlist' `controlvarlist' if `touse' &  `clustercount'>1	|| `cluster_l3': || `cluster_l2':  , intpoints(7) retolerance(1e-7) reiterate(100)  
	if  `varlevels'>2 		capture noisily 	mixed 		`varlist' `controlvarlist' if `touse' &  `clustercount'>1	|| `cluster_l3': || `cluster_l2':  , emiterate(50)  emtolerance(1e-8)  
	if _rc==0 {				  
		capture noisily estat icc  
		         
		mat def clusternumber=e(N_g)  
		mat def avclustersize=e(g_avg)  
		mat def minclustersize=e(g_min)  
		mat def maxclustersize=e(g_max)  
           
		scalar icc2_icc2_`structure'_`pointer' =r(icc2)						  
		scalar icc2_iccse2_`structure'_`pointer' =r(se2)					  
		scalar icc2_clused2_`structure'_`pointer' = clusternumber[1,2]		  
		scalar icc2_mean2_`structure'_`pointer'  	= avclustersize[1,2]	  
		scalar icc2_min2_`structure'_`pointer'  	= minclustersize[1,2]	  
		scalar icc2_max2_`structure'_`pointer'  	= maxclustersize[1,2]	  
           
		scalar icc2_icc3_`structure'_`pointer' =r(icc3)						  
		scalar icc2_iccse3_`structure'_`pointer' =r(se3)					  
		scalar icc2_clused3_`structure'_`pointer' = clusternumber[1,1]		  
		scalar icc2_mean3_`structure'_`pointer'  	= avclustersize[1,1]	  
		scalar icc2_min3_`structure'_`pointer'  	= minclustersize[1,1]	  
		scalar icc2_max3_`structure'_`pointer'  	= maxclustersize[1,1]	  
           
		scalar icc2_N_`structure'_`pointer' =e(N)							  
		scalar icc2_icc_`structure'_`pointer' =r(icc2)+	r(icc3)				  
           
		ereturn list  
		return list  
	}         
}          
           
dq_out_mac, text(icc2 `pointer')	andor(1)		  
           
foreach var in `controlvarlist' {  
	if strpos("`var'","___")>0 qui drop `var'  
}          
           
	          
end        
           
